unit AnimatedImage;

{-----------------------------------]
Program: Jeff Peters
Email: Jeffopeters@hotmail.com
Version: 1.0
Date: 9/22/2000 - 9/26/2000
Usage: Use in Place of Animated Gifs, you can have animated jpegs, bmps, icons!
Using Version: Delphi 4 Pro
Copyright: Free, but please email, me about it. Please send me comments about it
  or an idea of what to make, and I will send you it if I make it.
Dedicated To: Mr. King's Programing Computer Class
[-----------------------------------}

interface

uses
  Classes, Graphics, Controls, extctrls;


type
  TPoitionStyle = (psNone, psAutoSize, psCenter, psStretch);//Unique way of doing autosize, center...
  {TPictureFrameCollection and TPictureFrameCollectionItem are used with delphis build in
  TTCollectionItem and TCollection, it lets you add in an array of something,
  In this case, TPictures, It a lot of code, and you don't need to know this
  if you a beginner programmer, because it hard to explane.}
  TAnimatedImage = Class;

  TPictureFrameItem = class(TCollectionItem)
  private
    FPicture:TPicture;
    FName:String;
    FOnChange:TNotifyEvent;
  protected
    procedure SetPicture(Value:TPicture);
    procedure SetTransparent(Value:Boolean);
    function GetTransparent:Boolean;
    procedure SetHeight(Value:Integer);
    function GetHeight:Integer;
    procedure SetWidth(Value:Integer);
    function GetWidth:Integer;
    procedure SetName(const Value: string);
    function GetDisplayName: string;  override;
  public
    constructor Create(Collection: TCollection); override;
    procedure Assign(Source: TPersistent); override;
    property OnChange:TNotifyEvent Read FOnChange Write FOnChange;
  published
    property Picture:TPicture Read FPicture write SetPicture;
    property Transparent:Boolean Read GetTransparent Write SetTransparent;
    property Height:Integer Read GetHeight Write SetHeight;
    property Width:Integer Read GetWidth Write SetWidth;
    property Name:string read GetDisplayName write SetName;
  end;

  TPictureFrameCollection = Class(TCollection)
  private
    FOwner: TPersistent;
    FOnChange:TNotifyEvent;
    function GetItem(Index: Integer): TPictureFrameItem;
    procedure SetItem(Index: Integer; Value: TPictureFrameItem);
    function FindIndexFromName(AName:String):Integer;
    function GetNameItem(Name:String): TPictureFrameItem;
    procedure SetNameItem(Name:String; Value: TPictureFrameItem);
  protected
    function GetOwner: TPersistent; override;
  public
    constructor Create(AOwner : TPersistent);
    function Add: TPictureFrameItem;
    property Items[Index: Integer]: TPictureFrameItem read GetItem write SetItem; default;
    property FindItem[Name:String]: TPictureFrameItem read GetNameItem write SetNameItem;
    property OnChange:TNotifyEvent Read FOnChange Write FOnChange;
  end;

  {This is are main Component, it comes from TGraphicControl which lets you draw
  on the form.}
  TAnimatedImage = class(TPaintBox)
  private //The Varible belows are Not available for the user to use
    FPictureFrameCollection:TPictureFrameCollection; //More TCollection Stuff
    FFrameDraw,FFrameStart,FFrameStop:Cardinal; //Cardinal= nonnagtive Integer
    //FFrameDraw = What Pict Were are drawing Now
    //FFrameStart = What Pict to start the loop at
    //FFrameEnd = What Pict to end the loop at
    Timer:TTimer; //Like a normal TTimer on a form, used for the loop
    FPoitionStyle:TPoitionStyle; //To Draw centered, psStretch,...
    FDoRedraw:Boolean;
  protected
    procedure SetPictureFrameCollection(Value: TPictureFrameCollection);
    procedure Paint; override;
    procedure SetPoitionStyle(Value: TPoitionStyle);
    procedure TimerTimer(Sender: TObject);
    procedure SetActive(Value:Boolean);
    procedure SetInterval(Value:Cardinal);
    procedure SetFrameDraw(Value:Cardinal);
    function GetActive:Boolean;
    function GetInterval:Cardinal;
    procedure OnPictureFamesUpdate(Sender: TObject);
  public //Only The Varible below are available for the user to use
    Constructor Create(AOwner : TComponent); override;
    procedure Draw(Index:Integer);
  published
    property FrameDrawIndex:Cardinal Read FFrameDraw Write SetFrameDraw;
    property Frames: TPictureFrameCollection read FPictureFrameCollection write SetPictureFrameCollection;
    property PoitionStyle:TPoitionStyle read FPoitionStyle write SetPoitionStyle;
    property FrameStart:Cardinal Read FFrameStart Write FFrameStart;
    property FrameStop:Cardinal Read FFrameStop Write FFrameStop;
    property Active:Boolean Read GetActive Write SetActive;
    property Interval:Cardinal Read GetInterval Write SetInterval;
    property DoRedraw:Boolean Read FDoRedraw Write FDoRedraw;
  end;

procedure Register;

implementation

procedure Register;
begin
  //put this component on the Additional Tab
  RegisterComponents('Additional', [TAnimatedImage]);
end;

//-- TPictureFrameItem ------------------------------------------------------
constructor TPictureFrameItem.Create(Collection: TCollection);
begin
  inherited Create(Collection);
  FPicture := TPicture.Create;
  FPicture.OnChange := (Collection as TPictureFrameCollection).OnChange;
end;

procedure TPictureFrameItem.Assign(Source: TPersistent);
begin
  if Source is TPictureFrameCollection then
  begin
    Picture := TPictureFrameItem(Source).Picture;
    Transparent := TPictureFrameItem(Source).Transparent;
  end
  else inherited Assign(Source);
end;

procedure TPictureFrameItem.SetPicture(Value:TPicture);
begin
  FPicture.Assign(Value);
end;

procedure TPictureFrameItem.SetTransparent(Value:Boolean);
begin
  FPicture.Graphic.Transparent := Value;
end;

function TPictureFrameItem.GetTransparent:Boolean;
begin
  If FPicture.Graphic = nil Then
    Result := False
  else
    Result := FPicture.Graphic.Transparent;
end;

procedure TPictureFrameItem.SetHeight(Value:Integer);
begin
end;

function TPictureFrameItem.GetHeight:Integer;
begin
  If FPicture.Graphic = nil Then
    Result := 0
  else
    Result := FPicture.Graphic.Height;
end;

procedure TPictureFrameItem.SetWidth(Value:Integer);
begin
end;

function TPictureFrameItem.GetWidth:Integer;
begin
  If FPicture.Graphic = nil Then
    Result := 0
  else
    Result := FPicture.Graphic.Width;
end;

function TPictureFrameItem.GetDisplayName: string;
begin
  Result := FName;
  if Result = '' then Result := inherited GetDisplayName;
end;

procedure TPictureFrameItem.SetName(const Value: string);
begin
  if FName <> Value then begin
    FName := Value;
    Changed(True);
  end;
end;

//-- TPictureFrameCollection -----------------------------------------------------
constructor TPictureFrameCollection.Create(AOwner : TPersistent);
begin
  inherited Create(TPictureFrameItem);
  FOwner := AOwner;
end;

function TPictureFrameCollection.GetOwner: TPersistent;
begin
  Result := FOwner;
end;

function TPictureFrameCollection.Add: TPictureFrameItem;
begin
  Result := TPictureFrameItem(inherited Add);
end;

function TPictureFrameCollection.GetItem(Index: Integer): TPictureFrameItem;
begin
  Result := TPictureFrameItem(inherited GetItem(Index));
end;

procedure TPictureFrameCollection.SetItem(Index: Integer; Value: TPictureFrameItem);
begin
  inherited SetItem(Index, Value);
end;

function TPictureFrameCollection.FindIndexFromName(AName:String):Integer;
begin
  For Result := 0 To Count-1 do
    If Items[Result].FName = AName Then
      Exit;
  Result := 0;
end;

function TPictureFrameCollection.GetNameItem(Name:String): TPictureFrameItem;
begin
  Result := TPictureFrameItem(inherited GetItem(FindIndexFromName(Name)));
end;

procedure TPictureFrameCollection.SetNameItem(Name:String; Value: TPictureFrameItem);
begin
  inherited SetItem(FindIndexFromName(Name), Value);
end;


//-- TAnimatedImage -----------------------------------------------------------
Constructor TAnimatedImage.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  Timer := TTimer.Create(Self); //Create the Timer, Must to this
  FPictureFrameCollection := TPictureFrameCollection.Create(Self);
  FPictureFrameCollection.OnChange := OnPictureFamesUpdate;
  Active := False; //Start off inactive, we don't have any picts yet
  Timer.OnTimer := TimerTimer; //set up the timer procedure
  Height := 100;
  Width := 100;
end;

procedure TAnimatedImage.SetPictureFrameCollection(Value: TPictureFrameCollection);
begin
  FPictureFrameCollection.Assign(Value);
  FPictureFrameCollection.OnChange := OnPictureFamesUpdate;
end;

procedure TAnimatedImage.Paint;
Var
  Graphic:TGraphic;
begin
  with Canvas do begin
    Font := Font;
    Brush.Color := Color;
    If (FFrameDraw < Trunc(Frames.Count)) And (Frames.GetItem(FFrameDraw).Picture <> nil) Then begin
      Graphic := Frames.GetItem(FFrameDraw).Picture.Graphic; //Get the graphic
      If FPoitionStyle = psAutoSize Then //Set the size, if autosize
        SetBounds(Left, Top, Graphic.Width, Graphic.Height);
      case FPoitionStyle of //draw the pict, the way we want
        psNone: Draw(0,0,Graphic);
        psAutoSize: Draw(0,0,Graphic);
        psStretch: StretchDraw(Rect(0,0,Width,Height),Graphic);
        psCenter: Draw(Width div 2-Graphic.Width div 2,Height div 2-Graphic.Height div 2,Graphic);
      end; //Image Draw
    end; //Err Check
    if csDesigning in ComponentState then begin//Do this if we are in Design Mode, or not running the program
      Pen.Style := psDash;
      Brush.Style := bsClear;
      Rectangle(0, 0, Width, Height);
    end; //Rect Draw
  end; //With Canvas
  if Assigned(OnPaint) then OnPaint(Self);
end;

procedure TAnimatedImage.SetPoitionStyle(Value: TPoitionStyle);
begin
  FPoitionStyle := Value;
  Invalidate; //redraw after we set the PoitionStyle
end;

procedure TAnimatedImage.TimerTimer(Sender: TObject);
begin
  FFrameDraw := FFrameDraw +1; //Add 1 to the index
  If FFrameDraw > FFrameStop Then FFrameDraw := FFrameStart; //If over start over
  If FDoRedraw Then Invalidate else Paint;
end;

procedure TAnimatedImage.Draw(Index:Integer);
Var
  OldIndex:Cardinal;
begin
  OldIndex := FFrameDraw;
  FFrameDraw := Index;
  If FDoRedraw Then Invalidate else Paint;
  FFrameDraw := OldIndex;
end;

procedure TAnimatedImage.SetActive(Value:Boolean);
begin
  Timer.Enabled := Value;
end;

procedure TAnimatedImage.SetInterval(Value:Cardinal);
begin
  Timer.Interval := Value;
end;

function TAnimatedImage.GetActive:Boolean;
begin
  Result := Timer.Enabled;
end;

function TAnimatedImage.GetInterval:Cardinal;
begin
  Result := Timer.Interval;
end;

procedure TAnimatedImage.SetFrameDraw(Value:Cardinal);
begin
  If FFrameDraw <> Value Then Begin
   FFrameDraw := Value;
   If FDoRedraw Then Invalidate else Paint;
  end;
end;

procedure TAnimatedImage.OnPictureFamesUpdate(Sender: TObject);
begin
  If FDoRedraw Then Invalidate else Paint;
end;

end.
