// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'VBitmap.pas' rev: 5.00

#ifndef VBitmapHPP
#define VBitmapHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <StrMan.hpp>	// Pascal unit
#include <NumMan.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Vbitmap
{
//-- type declarations -------------------------------------------------------
typedef tagRGBQUAD TColorTable[536870911];

typedef tagRGBQUAD *PColorTable;

class DELPHICLASS TVirtualBitmap;
class PASCALIMPLEMENTATION TVirtualBitmap : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Graphics::TBrush* fBrush;
	Graphics::TPen* fPen;
	int fWidth;
	int fHeight;
	int fColors;
	tagRGBQUAD *fColorTable;
	int ClrTableSize;
	float ColorSize;
	int fSkip;
	bool fAntialiased;
	int fBits;
	Classes::TMemoryStream* fContent;
	void __fastcall SetWidth(int Value);
	void __fastcall SetHeight(int Value);
	void __fastcall SetColor(Byte i, Graphics::TColor Value);
	Graphics::TColor __fastcall GetColor(Byte i);
	void __fastcall SetBits(int Value);
	bool __fastcall CheckTable(void);
	void __fastcall SetPen(Graphics::TPen* Val);
	void __fastcall SetBrush(Graphics::TBrush* Val);
	void __fastcall GotoXY(int x, int y);
	void __fastcall ValidXY(int &x1, int &y1, int &x2, int &y2);
	
protected:
	virtual void __fastcall RecreateContent(void);
	
public:
	__fastcall TVirtualBitmap(int AWidth, int AHeight, int ABits);
	__fastcall TVirtualBitmap(Graphics::TBitmap* Bitmap);
	void __fastcall LoadFromStream(Classes::TStream* Stream);
	__fastcall ~TVirtualBitmap(void);
	int __fastcall GetPixel(int x, int y);
	void __fastcall SetPixel(int x, int y, int Color);
	void __fastcall ProduceBitmap(Graphics::TBitmap* Bitmap);
	int __fastcall GetNearestColor(int Color);
	void __fastcall Draw(int x, int y, TVirtualBitmap* Src);
	void __fastcall Line(int x1, int y1, int x2, int y2);
	void __fastcall Rectangle(int x1, int y1, int x2, int y2);
	__property Classes::TMemoryStream* Content = {read=fContent};
	__property Graphics::TPen* Pen = {read=fPen, write=SetPen};
	__property Graphics::TBrush* Brush = {read=fBrush, write=SetBrush};
	__property int Width = {read=fWidth, write=SetWidth, nodefault};
	__property int Height = {read=fHeight, write=SetHeight, nodefault};
	__property int Colors = {read=fColors, nodefault};
	__property bool AntiAliase = {read=fAntialiased, write=fAntialiased, nodefault};
	__property int Bits = {read=fBits, write=SetBits, nodefault};
	__property Graphics::TColor ColorTable[Byte i] = {read=GetColor, write=SetColor};
};


//-- var, const, procedure ---------------------------------------------------

}	/* namespace Vbitmap */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Vbitmap;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// VBitmap
