// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Gradient.pas' rev: 5.00

#ifndef GradientHPP
#define GradientHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <DrawMan.hpp>	// Pascal unit
#include <ColorMan.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Gradient
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TGradientStyle { gsLine, gsEllipse, gsRect, gsCustomRect };
#pragma option pop

typedef Shortint TColorCount;

#pragma option push -b-
enum TDirection { diHorizonal, diVertical };
#pragma option pop

typedef void __fastcall (__closure *TDrawRectEvent)(System::TObject* Sender, Graphics::TCanvas* Canvas
	, const Windows::TRect &Rect);

class DELPHICLASS TGradient;
class PASCALIMPLEMENTATION TGradient : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	TGradientStyle fGradientStyle;
	int fLineSize;
	Graphics::TColor fColor1;
	Graphics::TColor fColor2;
	Graphics::TColor fColor3;
	Graphics::TColor fColor4;
	Graphics::TColor fColor5;
	TColorCount fColorCount;
	Classes::TNotifyEvent fOnChange;
	TDirection fLineDirection;
	TDrawRectEvent fOnDrawRect;
	void __fastcall SetGradientStyle(TGradientStyle Value);
	void __fastcall SetLineSize(int Value);
	void __fastcall SetColor1(Graphics::TColor Value);
	void __fastcall SetColor2(Graphics::TColor Value);
	void __fastcall SetColor3(Graphics::TColor Value);
	void __fastcall SetColor4(Graphics::TColor Value);
	void __fastcall SetColor5(Graphics::TColor Value);
	void __fastcall SetColorCount(TColorCount Value);
	void __fastcall SetLineDir(TDirection Value);
	
public:
	__fastcall TGradient(void);
	HIDESBASE void __fastcall Assign(TGradient* Value);
	void __fastcall Changed(void);
	
__published:
	__property TGradientStyle GradientStyle = {read=fGradientStyle, write=SetGradientStyle, nodefault};
		
	__property int LineSize = {read=fLineSize, write=SetLineSize, nodefault};
	__property Graphics::TColor Color1 = {read=fColor1, write=SetColor1, nodefault};
	__property Graphics::TColor Color2 = {read=fColor2, write=SetColor2, nodefault};
	__property Graphics::TColor Color3 = {read=fColor3, write=SetColor3, nodefault};
	__property Graphics::TColor Color4 = {read=fColor4, write=SetColor4, nodefault};
	__property Graphics::TColor Color5 = {read=fColor5, write=SetColor5, nodefault};
	__property TColorCount ColorCount = {read=fColorCount, write=SetColorCount, nodefault};
	__property TDirection LineDirection = {read=fLineDirection, write=SetLineDir, nodefault};
	__property TDrawRectEvent OnDrawRect = {read=fOnDrawRect, write=fOnDrawRect};
	__property Classes::TNotifyEvent OnChange = {read=fOnChange, write=fOnChange};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TGradient(void) { }
	#pragma option pop
	
};


class DELPHICLASS TDfGradient;
class PASCALIMPLEMENTATION TDfGradient : public Controls::TGraphicControl 
{
	typedef Controls::TGraphicControl inherited;
	
private:
	TGradient* fGradient;
	Graphics::TBitmap* fTmp;
	void __fastcall SetGradient(TGradient* Value);
	void __fastcall CreateOnTmp(void);
	void __fastcall GradChanged(System::TObject* Sender);
	HIDESBASE MESSAGE void __fastcall CMColorChanged(Messages::TMessage &Message);
	
protected:
	virtual void __fastcall Paint(void);
	
public:
	__fastcall virtual TDfGradient(Classes::TComponent* AOwner);
	__fastcall virtual ~TDfGradient(void);
	
__published:
	__property TGradient* Gradient = {read=fGradient, write=SetGradient};
	__property Color ;
	__property Align ;
	__property Visible ;
	__property OnClick ;
	__property OnDblClick ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void __fastcall PaintGradient(Graphics::TCanvas* Canvas, const Windows::TRect &Rect, 
	TGradient* Gradient);
extern PACKAGE void __fastcall EllipseGradient(Graphics::TCanvas* Canvas, const Windows::TRect &Rect
	, const Graphics::TColor * Colors, const int Colors_Size, int ColorCount, int LineSize);
extern PACKAGE void __fastcall CustomGradient(Graphics::TCanvas* Canvas, const Windows::TRect &Rect, 
	const Graphics::TColor * Colors, const int Colors_Size, int ColorCount, int LineSize, TDrawRectEvent 
	OnDraw);
extern PACKAGE void __fastcall RectGradient(Graphics::TCanvas* Canvas, const Windows::TRect &Rect, const 
	Graphics::TColor * Colors, const int Colors_Size, int ColorCount, int LineSize);
extern PACKAGE void __fastcall FastLineGrad(Graphics::TCanvas* Canvas, const Windows::TRect &Rect, const 
	Graphics::TColor * Colors, const int Colors_Size, int ColorCount, TDirection Direction, int LineSize
	);
extern PACKAGE void __fastcall LineGradient(Graphics::TCanvas* Canvas, const Windows::TRect &Rect, const 
	Graphics::TColor * Colors, const int Colors_Size, int ColorCount, TDirection Direction, int LineSize
	);

}	/* namespace Gradient */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Gradient;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Gradient
